//=============================================================================
// Bass Guitar :P sounds by zillionsounds
//=============================================================================
class ElectricBassGuitar extends DeusExWeapon;

var travel int TuneMode;
var() string TuneCycleMessages[8];
var() sound GuitarNotes[8];
var() class<projectile> WaveClass;

replication
{
     reliable if (Role == ROLE_Authority)
        TuneMode;
}

simulated function ReloadAmmo()
{
	TuneMode -= 1;
	if(TuneMode < 0)
	{
		TuneMode = 7;
	}
	DeusExPlayer(Owner).ClientMessage(TuneCycleMessages[TuneMode]);
}

simulated function ScopeToggle()
{
	TuneMode -= 2;
	if(TuneMode < 0)
	{
		TuneMode += 8;
	}
	DeusExPlayer(Owner).ClientMessage(TuneCycleMessages[TuneMode]);
}

simulated function cycleammo()
{
	TuneMode += 1;
	if(TuneMode > 7)
	{
		TuneMode = 0;
	}
	DeusExPlayer(Owner).ClientMessage(TuneCycleMessages[TuneMode]);
}

simulated function LaserToggle()
{
	TuneMode += 2;
	if(TuneMode > 7)
	{
		TuneMode -= 8;
	}
	DeusExPlayer(Owner).ClientMessage(TuneCycleMessages[TuneMode]);
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 9);
}

function Fire( float Value )
{
       local DeusExPlayer P;
       local Projectile SoundWaveThingy;


  PlaySound(GuitarNotes[TuneMode], SLOT_None,, True);
  SoundWaveThingy = Spawn(WaveClass,,,Owner.Location, Pawn(Owner).ViewRotation);
  SoundWaveThingy.ImpactSound = GuitarNotes[TuneMode];
  if (SoundWaveThingy.IsA('ElectricSoundWave'))
   ElectricSoundWave(SoundWaveThingy).FanClass = class'DeusEx.Hooker2';
}

defaultproperties
{
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=0.000000
     EnviroEffective=ENVEFF_Air
     ShotTime=0.200000
     reloadTime=0.0001
     maxRange=24000
     AccurateRange=14400
     bCanHaveScope=True
     bHasMuzzleFlash=False
     FireOffset=(X=-20.000000,Y=2.000000,Z=30.000000)
     ProjectileClass=None
     shakemag=0.000000
     InventoryGroup=255
     ReloadCount=0
     ItemName="|p3Electric Bass Guitar"
     PickupViewMesh=LodMesh'DeusExItems.CombatKnifePickup'
     PickupViewScale=0.610000
     ThirdPersonMesh=LodMesh'DeusExItems.CombatKnife3rd'
     ThirdPersonScale=0.610000
     Fatness=200
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconLAW'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLAW'
     largeIconWidth=166
     largeIconHeight=47
     invSlotsX=5
     Description="A utlity gun used for installing security grids, simply choose what to select or spawn with your change ammo button and what viewpoint for the terminal window to control with your laser toggle button."
     beltDescription="ELEC-BASS"
     Mesh=LodMesh'DeusExItems.LAWPickup'
     CollisionRadius=27.000000
     CollisionHeight=6.600000
     Mass=5.000000"
     bCanHaveScope=True
     bHasScope=True
     BaseAccuracy=0.000000
     PlayerViewScale=0.000000
     WaveClass=class'MSGuitar1_1.ElectricSoundWave'
     TuneCycleMessages(0)="|p3Tune set to A note"
     TuneCycleMessages(1)="|p3Tune set to B note"
     TuneCycleMessages(2)="|p3Tune set to C note"
     TuneCycleMessages(3)="|p3Tune set to D note"
     TuneCycleMessages(4)="|p3Tune set to E note"
     TuneCycleMessages(5)="|p3Tune set to F note"
     TuneCycleMessages(6)="|p3Tune set to G note"
     TuneCycleMessages(7)="|cf88Tune set to Open note"
     GuitarNotes(0)=sound'MSGuitar1_1.Misc.EBNoteA'
     GuitarNotes(1)=sound'MSGuitar1_1.Misc.EBNoteB'
     GuitarNotes(2)=sound'MSGuitar1_1.Misc.EBNoteC'
     GuitarNotes(3)=sound'MSGuitar1_1.Misc.EBNoteD'
     GuitarNotes(4)=sound'MSGuitar1_1.Misc.EBNoteE'
     GuitarNotes(5)=sound'MSGuitar1_1.Misc.EBNoteF'
     GuitarNotes(6)=sound'MSGuitar1_1.Misc.EBNoteG'
     GuitarNotes(7)=sound'MSGuitar1_1.Misc.EOpenNote'
}
